"use client";

import { useState } from "react";
import { Formik, Form, Field } from "formik";
import { FaDollarSign } from "react-icons/fa";

const ProductForm = () => {
  const [selectedWarranty, setSelectedWarranty] = useState<string[]>([]);
  const [warrantyPrices, setWarrantyPrices] = useState<{ [key: string]: number }>({});

  const categories = ["Fashion & Beauty", "Electronics", "Home Appliances"];
  const subCategories = ["BAGS", "Shoes", "Watches"];
  const childCategories = ["Men", "Women", "Kids"];

  const warrantyOptions = [
    "No Warranty",
    "Local seller Warranty",
    "Non local warranty",
    "International Manufacturer Warranty",
    "International Seller Warranty",
  ];

  const handleWarrantyPriceChange = (type: string, value: string) => {
    setWarrantyPrices({
      ...warrantyPrices,
      [type]: parseFloat(value),
    });
  };

  const handleWarrantyCheckbox = (option: string) => {
    setSelectedWarranty((prev) =>
      prev.includes(option) ? prev.filter((item) => item !== option) : [...prev, option]
    );
  };

  return (
    <Formik
      initialValues={{
        productName: "",
        productSku: "",
        category: "",
        subCategory: "",
        childCategory: "",
        allowMeasurement: false,
      }}
      onSubmit={(values) => {
        const fullData = {
          ...values,
          selectedWarranty,
          warrantyPrices,
        };

        console.log(" Full Form Data:", fullData);
        alert("Check console for full form data");
      }}
    >
      {({ values, handleChange }) => (
        <Form className="mx-auto bg-white rounded space-y-6 text-sm text-[#0D3359]">
          <div>
            <label className="font-semibold">Product Name* (in Any Language)</label>
            <Field
              type="text"
              name="productName"
              placeholder="Physical Product Title Title will be Here 99"
              className="w-full border border-gray-300 px-3 py-2 mt-1 rounded focus:outline-none focus:ring-2 focus:ring-blue-200"
            />
          </div>

          <div>
            <label className="font-semibold">Product Sku*</label>
            <Field
              type="text"
              name="productSku"
              placeholder="Tcv6794KXS1"
              className="w-full border border-gray-300 px-3 py-2 mt-1 rounded focus:outline-none focus:ring-2 focus:ring-blue-200"
            />
          </div>

          <div>
            <label className="font-semibold">Category*</label>
            <Field
              as="select"
              name="category"
              className="w-full border border-gray-300 px-3 py-2 mt-1 rounded focus:outline-none focus:ring-2 focus:ring-blue-200"
            >
              <option value="">Select Category</option>
              {categories.map((cat, index) => (
                <option key={index} value={cat}>
                  {cat}
                </option>
              ))}
            </Field>
          </div>

          <div>
            <label className="font-semibold">Sub Category*</label>
            <Field
              as="select"
              name="subCategory"
              className="w-full border border-gray-300 px-3 py-2 mt-1 rounded focus:outline-none focus:ring-2 focus:ring-blue-200"
            >
              <option value="">Select Sub Category</option>
              {subCategories.map((sub, index) => (
                <option key={index} value={sub}>
                  {sub}
                </option>
              ))}
            </Field>
          </div>

          <div>
            <label className="font-semibold">Child Category*</label>
            <Field
              as="select"
              name="childCategory"
              className="w-full border border-gray-300 px-3 py-2 mt-1 rounded focus:outline-none focus:ring-2 focus:ring-blue-200"
            >
              <option value="">Select Child Category</option>
              {childCategories.map((child, index) => (
                <option key={index} value={child}>
                  {child}
                </option>
              ))}
            </Field>
          </div>

          <div>
            <label className="font-semibold">Warranty Type *</label>
            <div className="space-y-3 mt-2">
              {warrantyOptions.map((option, idx) => (
                <div key={idx} className="flex flex-col md:flex-row md:items-center md:justify-between gap-2">
                  <label className="inline-flex items-center">
                    <input
                      type="checkbox"
                      checked={selectedWarranty.includes(option)}
                      onChange={() => handleWarrantyCheckbox(option)}
                      className="mr-2"
                    />
                    {option}
                  </label>
                  <div className="flex items-center gap-2 mb-7 w-full md:w-[400px]">
                    <span className="text-lg font-semibold">+</span>
                    <div className="relative flex-1">
                      <span className="absolute inset-y-0 left-0 flex items-center pl-3 text-[#465541] text-sm bg-[#F1F1F1] px-2 rounded-l">
                        <FaDollarSign />
                      </span>
                      <input
                        type="text"
                        placeholder="0.00 (Additional Price)"
                        onChange={(e) => handleWarrantyPriceChange(option, e.target.value)}
                        value={warrantyPrices[option] || ""}
                        className="w-full pl-10 pr-3 py-2 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-blue-200 text-sm"
                      />
                    </div>
                  </div>
                </div>
              ))}
            </div>
          </div>

          <div className="flex flex-col gap-2">
            <label className="inline-flex items-center">
              <Field type="checkbox" name="allowMeasurement" className="mr-2" />
              Allow Product Measurement
            </label>
          </div>

          <button
            type="submit"
            className="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700 transition cuesor-pointer"
          >
            Submit
          </button>
        </Form>
      )}
    </Formik>
  );
};

export default ProductForm;
